/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.data.HeightUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportFromMapPacket
extends BaseC2SMessage {
    public final int x;
    public final int y;
    public final int z;
    public final boolean unknownY;
    public final ResourceKey<Level> dimension;

    public TeleportFromMapPacket(int _x, int _y, int _z, boolean uy, ResourceKey<Level> d) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.unknownY = uy;
        this.dimension = d;
    }

    TeleportFromMapPacket(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.unknownY = buf.readBoolean();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
    }

    public MessageType getType() {
        return FTBChunksNet.TELEPORT_FROM_MAP;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.unknownY);
        buf.m_130085_(this.dimension.m_135782_());
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer p = (ServerPlayer)context.getPlayer();
        ServerLevel level = p.m_20194_().m_129880_(this.dimension);
        if (level != null && p.m_20310_(2)) {
            int y1 = this.y;
            if (this.unknownY) {
                ChunkAccess chunkAccess = level.m_6522_(this.x >> 4, this.z >> 4, ChunkStatus.f_62326_, true);
                if (chunkAccess == null) {
                    return;
                }
                int topY = chunkAccess.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.x, this.z);
                if (topY == chunkAccess.m_141937_() - 1) {
                    return;
                }
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.x, topY + 2, this.z);
                int water = HeightUtils.getHeight((Level)level, chunkAccess, blockPos);
                if (blockPos.m_123342_() == -32767) {
                    blockPos.m_142448_(70);
                } else if (water != -32767) {
                    blockPos.m_142448_(Math.max(blockPos.m_123342_(), water));
                }
                y1 = blockPos.m_123342_() + 1;
            }
            p.m_8999_(level, (double)this.x + 0.5, (double)y1 + 0.1, (double)this.z + 0.5, p.m_146908_(), p.m_146909_());
        }
    }
}

